<?php
// 1. Ambil data asli dan mapping tim
$all_matches = $matches ?? [];
$teams_data = $data['teams'] ?? [];

$team_lookup = [];
foreach ($teams_data as $t) {
    $team_lookup[$t['id']] = [
        'name' => $t['name'],
        'logo' => !empty($t['logo']) ? "assets/img/teams/".$t['logo'] : "https://ui-avatars.com/api/?name=".urlencode($t['name'])."&background=222&color=d4af37"
    ];
}

// 2. LOGIKA FILTER: Hanya ambil status 'Upcoming' dan batasi maksimal 2
$upcoming_matches = array_filter($all_matches, function($m) {
    return ($m['status'] ?? '') === 'Upcoming';
});

// Ambil 2 teratas (pertandingan terdekat)
$limited_matches = array_slice($upcoming_matches, 0, 2);
?>

<div class="schedule-container" style="padding: 0 5px;">
    <?php if (empty($limited_matches)): ?>
        <div style="text-align:center; padding:30px; background:#0a0a0a; border-radius:20px; border:1px dashed #222;">
            <span class="material-icons-outlined" style="font-size:32px; color:#333; margin-bottom:10px;">event_available</span>
            <p style="color:#555; font-size:0.75rem; margin:0;">Belum ada jadwal pertandingan baru.</p>
        </div>
    <?php else: ?>
        
        <?php foreach ($limited_matches as $m): 
            $t_a = $team_lookup[$m['team_a_id']] ?? ['name' => 'TBA', 'logo' => ''];
            $t_b = $team_lookup[$m['team_b_id']] ?? ['name' => 'TBA', 'logo' => ''];
        ?>
            <div class="match-card-public" style="background: linear-gradient(145deg, #0d0d0d, #050505); border: 1px solid #1a1a1a; border-radius:22px; padding:20px; margin-bottom:15px; position:relative;">
                
                <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:18px;">
                    <div style="display:flex; align-items:center; gap:6px;">
                        <span class="material-icons-outlined" style="font-size:14px; color:var(--gold);">calendar_today</span>
                        <span style="font-size:0.6rem; color:#555; font-weight:800; letter-spacing:1px; text-transform:uppercase;">
                            <?php echo $m['season'] ?? 'Tournament'; ?>
                        </span>
                    </div>
                    <span style="border:1px solid #222; color:var(--gold); font-size:0.55rem; padding:3px 10px; border-radius:20px; font-weight:900; letter-spacing:1px;">NEXT MATCH</span>
                </div>

                <div style="display:grid; grid-template-columns: 1fr 40px 1fr; align-items:center; text-align:center;">
                    <div style="display:flex; flex-direction:column; align-items:center; gap:10px;">
                        <img src="<?php echo $t_a['logo']; ?>" style="width:55px; height:55px; border-radius:18px; object-fit:cover; border:1px solid #1a1a1a; background:#000;">
                        <span style="font-weight:900; font-size:0.85rem; color:white; letter-spacing:0.5px;"><?php echo $t_a['name']; ?></span>
                    </div>

                    <div style="font-family:'Cinzel'; color:var(--gold); font-weight:bold; font-size:0.9rem; opacity:0.3;">VS</div>

                    <div style="display:flex; flex-direction:column; align-items:center; gap:10px;">
                        <img src="<?php echo $t_b['logo']; ?>" style="width:55px; height:55px; border-radius:18px; object-fit:cover; border:1px solid #1a1a1a; background:#000;">
                        <span style="font-weight:900; font-size:0.85rem; color:white; letter-spacing:0.5px;"><?php echo $t_b['name']; ?></span>
                    </div>
                </div>

                <div style="margin-top:20px; padding:12px; background:rgba(255,255,255,0.02); border-radius:12px; display:flex; justify-content:center; align-items:center; gap:8px;">
                    <span class="material-icons-outlined" style="font-size:16px; color:#444;">schedule</span>
                    <span style="font-size:0.7rem; font-weight:800; color:#888; letter-spacing:0.5px;"><?php echo $m['date']; ?> — <?php echo $m['time']; ?> WIB</span>
                </div>
            </div>
        <?php endforeach; ?>

        <div style="text-align:center; margin-top:10px;">
    <a href="index.php?page=schedule" class="hero-btn-pro" style="padding: 10px 20px; font-size: 0.65rem; background: none; border: 1px solid #222; color: #888; box-shadow: none;">
        LIHAT JADWAL SELENGKAPNYA 
        <span class="material-icons-outlined" style="font-size:14px;">arrow_forward</span>
    </a>
</div>

    <?php endif; ?>
</div>