<?php
// --- PHP LOGIC (Tidak Berubah) ---
$ui = $data['ui_settings'] ?? [
    "hero_banner" => "default-hero.jpg",
    "announcement" => "SEASON 1: THE RISE OF EMPIRES"
];

// Pastikan path ini benar relatif dari file index.php utama
$hero_bg_path = "assets/img/ui/" . ($ui['hero_banner'] ?? '');

// Cek ketersediaan file, jika tidak ada gunakan placeholder
if (empty($ui['hero_banner']) || !file_exists($hero_bg_path)) {
    // Placeholder image jika gambar tidak ditemukan
    $hero_bg_src = "https://images.unsplash.com/photo-1548294576-093457f64850?q=80&w=1920&auto=format&fit=crop";
} else {
    // Tambahkan timestamp agar browser tidak menyimpan cache gambar lama saat diupdate
    $hero_bg_src = $hero_bg_path . "?v=" . time();
}
?>

<header class="hero-section">
    
    <img src="<?php echo $hero_bg_src; ?>" alt="Hero Background" class="hero-bg-img">
    
    <div class="hero-overlay"></div>

    <div class="hero-content">
        
        <div style="margin-bottom: 20px;">
            <span class="badge-coming-soon">COMING SOON</span>
        </div>

        <div class="hero-brand">
            <span class="hero-tag">AOE</span>
            <h1 class="hero-title">NUSANTARA <span>LEAGUE</span></h1>
        </div>

        <p class="hero-subtitle">
            <?php echo $ui['announcement']; ?>
        </p>

        <div style="margin-top: 35px;">
            <a href="?page=details" class="hero-btn-pro">
                BACA SELENGKAPNYA
                <span class="material-icons-outlined" style="font-size:18px;">arrow_forward</span>
            </a>
        </div>
    </div>
</header>

<style>
    /* Container Utama */
    .hero-section {
        height: 85vh; /* Sedikit lebih tinggi */
        position: relative; /* Penting untuk absolute children */
        display: flex;
        align-items: center;
        justify-content: center;
        text-align: center;
        padding: 0 20px;
        overflow: hidden; /* Mencegah gambar bocor keluar */
    }

    /* 1. IMPLEMENTASI GAMBAR IMG DI BELAKANG */
    .hero-bg-img {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        object-fit: cover; /* Memastikan gambar mengisi area tanpa gepeng */
        z-index: 0; /* Layer paling belakang */
    }

    /* Layer Overlay Gelap di atas gambar */
    .hero-overlay {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: linear-gradient(to bottom, rgba(0,0,0,0.4), rgba(0,0,0,0.95));
        z-index: 1; /* Di atas gambar */
    }

    /* Konten agar tampil di paling depan */
    .hero-content {
        position: relative;
        z-index: 2; /* Layer paling depan */
    }

    /* 2. STYLE BARU LABEL COMING SOON (HIJAU) */
    .badge-coming-soon {
        display: inline-block;
        background: #27ae60; /* Warna Hijau Solid */
        color: white; /* Teks Putih */
        padding: 6px 18px;
        border-radius: 50px;
        font-size: 0.65rem;
        font-weight: 900;
        letter-spacing: 2px;
        text-transform: uppercase;
        box-shadow: 0 5px 15px rgba(39, 174, 96, 0.4); /* Shadow hijau */
        animation: pulse-green 2s infinite;
    }

    /* Animasi Pulse Hijau Halus */
    @keyframes pulse-green {
        0% { transform: scale(1); box-shadow: 0 0 0px rgba(39, 174, 96, 0); }
        50% { transform: scale(1.05); box-shadow: 0 0 20px rgba(39, 174, 96, 0.5); }
        100% { transform: scale(1); box-shadow: 0 0 0px rgba(39, 174, 96, 0); }
    }

    /* --- Style elemen lain (Brand, Title, Button) tetap sama --- */
    .hero-brand { margin-bottom: 15px; }
    .hero-tag { font-family: 'Cinzel', serif; font-size: 0.9rem; color: #fff; letter-spacing: 8px; display: block; opacity: 0.8; margin-bottom: 5px; }
    .hero-title { font-family: 'Cinzel', serif; font-size: 2.5rem; color: var(--gold); margin: 0; line-height: 1; font-weight: 900; text-shadow: 0 4px 30px rgba(0,0,0,0.8); }
    .hero-title span { color: #fff; display: block; font-size: 2rem; }
    .hero-subtitle { font-size: 0.8rem; color: #ccc; letter-spacing: 2px; text-transform: uppercase; max-width: 300px; margin: 20px auto 0; line-height: 1.6; font-weight: bold; }
    .hero-btn-pro { display: inline-flex; align-items: center; gap: 10px; background: var(--gold); color: #000; text-decoration: none; padding: 16px 35px; border-radius: 50px; font-weight: 900; font-size: 0.75rem; letter-spacing: 1px; box-shadow: 0 10px 30px rgba(212, 175, 55, 0.3); transition: 0.3s; }
    .hero-btn-pro:active { transform: scale(0.95); filter: brightness(0.9); }
</style>