<?php
/**
 * INDEX.PHP - Gerbang Utama (Frontend)
 * AOE Nusantara League - Age of Empires II Tournament
 */

// 1. SETTING PATH & CACHE BUSTER
$data_path = 'data/data.json';
$cache_buster = time(); 

// 2. LOAD DATA DARI JSON
if (file_exists($data_path)) {
    $json_content = file_get_contents($data_path);
    $data = json_decode($json_content, true);
} else {
    $data = ["teams" => [], "matches" => [], "players" => [], "ui_settings" => []];
}

// Ekstraksi Variabel Global agar bisa langsung dipakai di sub-pages
$matches = $data['matches'] ?? []; 
$players = $data['players'] ?? [];
$ui_settings = $data['ui_settings'] ?? [];

// 3. LOGIKA SORTING KLASEMEN
$teams = $data['teams'] ?? [];
usort($teams, function($a, $b) {
    $ptsA = $a['points'] ?? 0;
    $ptsB = $b['points'] ?? 0;
    if ($ptsA == $ptsB) {
        return ($b['win'] ?? 0) <=> ($a['win'] ?? 0);
    }
    return $ptsB <=> $ptsA;
});

// 4. ROUTING LOGIC
$page = $_GET['page'] ?? 'home';
$team_id = $_GET['id'] ?? null;

// Tentukan target file berdasarkan page
switch ($page) {
    case 'schedule':
        $target = 'pages/schedule.php';
        break;
    case 'details':
        $target = 'pages/turnament-details.php';
        break;
    case 'team':
        $target = 'pages/team-profile.php';
        break;
    case 'home':
    default:
        $target = 'pages/home.php';
        break;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>AOE Nusantara League | AoE2 Indonesia</title>
    
    <link rel="stylesheet" href="assets/style.css?v=<?php echo $cache_buster; ?>">
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@700;900&family=Roboto:wght@300;400;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons+Outlined" rel="stylesheet">

    <style>
        :root {
            --gold: #d4af37;
            --dark: #000;
            --border: #1a1a1a;
        }
        body { 
            background: var(--dark); 
            margin: 0; 
            color: #eee; 
            font-family: 'Roboto', sans-serif; 
            padding-bottom: 80px;
        }

        /* HEADER 2 GRID */
        .public-header {
            display: flex;
            flex-direction: column;
            align-items: center;
            padding: 40px 20px 30px;
            text-align: center;
        }
        .h-top { 
            font-family: 'Cinzel', serif; 
            font-size: 0.8rem; 
            color: #444; 
            letter-spacing: 6px;
            margin-bottom: 2px;
            font-weight: 700;
        }
        .h-main { 
            font-family: 'Cinzel', serif; 
            font-size: 1.4rem; 
            color: var(--gold); 
            letter-spacing: 1px;
            font-weight: 900;
            text-transform: uppercase;
        }
        .h-main span { color: white; }

        /* BOTTOM NAVIGATION */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 70px;
            background: rgba(10, 10, 10, 0.95);
            backdrop-filter: blur(10px);
            border-top: 1px solid var(--border);
            display: flex;
            justify-content: space-around;
            align-items: center;
            z-index: 9999;
        }
        .nav-item {
            text-decoration: none;
            color: #555;
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 4px;
            flex: 1;
            transition: 0.3s;
        }
        .nav-item span { font-size: 1.5rem; }
        .nav-item label { font-size: 0.6rem; font-weight: bold; cursor: pointer; text-transform: uppercase; letter-spacing: 1px; }
        .nav-item.active { color: var(--gold); }

        .main-footer {
            text-align: center;
            padding: 40px 20px;
            border-top: 1px solid var(--border);
            margin-top: 20px;
        }
    </style>
</head>
<body>

    <main class="mobile-container">
        
        <header class="public-header">
            <div class="h-top">AOE</div>
            <div class="h-main">NUSANTARA <span>LEAGUE</span></div>
        </header>

        <?php 
            if (file_exists($target)) {
                require $target;
            } else {
                echo "<section style='padding:100px 20px; text-align:center;'>
                        <span class='material-icons-outlined' style='font-size:48px; color:#222;'>explore_off</span>
                        <p style='color:#444; margin-top:10px; font-family:Cinzel;'>Wilayah belum terpetakan (404).</p>
                        <a href='index.php' style='color:var(--gold); font-size:0.8rem; text-decoration:none;'>Kembali ke Beranda</a>
                      </section>";
            }
        ?>

        <footer class="main-footer">
            <p style="font-size:0.7rem; color:#666;">&copy; 2026 Age of Empires II Indonesia</p>
            <p style="margin-top:5px; color:var(--gold); font-size:0.6rem; font-family:'Cinzel'; letter-spacing:2px;">AOE NUSANTARA LEAGUE — SEASON 1</p>
        </footer>

        <nav class="bottom-nav">
            <a href="index.php?page=home" class="nav-item <?php echo $page == 'home' ? 'active' : ''; ?>">
                <span class="material-icons-outlined">home</span>
                <label>BERANDA</label>
            </a>
            <a href="index.php?page=schedule" class="nav-item <?php echo $page == 'schedule' ? 'active' : ''; ?>">
                <span class="material-icons-outlined">calendar_today</span>
                <label>JADWAL</label>
            </a>
            <a href="index.php?page=home#klasemen" class="nav-item">
                <span class="material-icons-outlined">emoji_events</span>
                <label>KLASEMEN</label>
            </a>
            <a href="index.php?page=details" class="nav-item <?php echo $page == 'details' ? 'active' : ''; ?>">
                <span class="material-icons-outlined">info</span>
                <label>INFO</label>
            </a>
        </nav>

    </main>

    <script>
        console.log("AOE Nusantara League Engine Active.");
    </script>
</body>
</html>