<?php
/**
 * ANL CLOUD IDE - Desktop Version
 * Professional Folder Management & Code Editor
 */
session_start();

// 1. CONFIG & SECURITY
$admin_password = "#ANLadmin26"; 
$root_dir = realpath(__DIR__ . '/../'); // Root folder website

if (isset($_POST['login'])) {
    if ($_POST['password'] === $admin_password) { $_SESSION['ftp_logged_in'] = true; }
}
if (isset($_GET['logout'])) { session_destroy(); header("Location: index.php"); exit; }

if (!isset($_SESSION['ftp_logged_in'])) {
    echo '<body style="background:#050505;color:#d4af37;display:flex;align-items:center;justify-content:center;height:100vh;font-family:sans-serif;margin:0;">
            <form method="POST" style="text-align:center;background:#0a0a0a;padding:50px;border-radius:30px;border:1px solid #1a1a1a;box-shadow:0 20px 50px rgba(0,0,0,0.5);">
                <h1 style="font-family:serif;letter-spacing:5px;margin:0 0 10px;">ANL CLOUD</h1>
                <p style="color:#444;font-size:0.7rem;margin-bottom:30px;letter-spacing:2px;">SECURE FILE MANAGEMENT</p>
                <input type="password" name="password" placeholder="ACCESS KEY" style="padding:15px;width:250px;border-radius:12px;border:1px solid #222;background:#000;color:white;text-align:center;outline:none;border-color:var(--gold);"><br><br>
                <button type="submit" name="login" style="padding:15px 40px;background:#d4af37;border:none;border-radius:12px;font-weight:bold;cursor:pointer;transition:0.3s;">UNLOCK SYSTEM</button>
            </form>
          </body>';
    exit;
}

// 2. LOGIKA NAVIGASI
$current_rel_path = $_GET['dir'] ?? '';
$current_full_path = realpath($root_dir . '/' . $current_rel_path);

if (!$current_full_path || strpos($current_full_path, $root_dir) !== 0) {
    $current_full_path = $root_dir;
    $current_rel_path = '';
}

// 3. ACTIONS (SAVE, RENAME, DELETE, CREATE)
$msg = "";

if (isset($_POST['save_file'])) {
    $target = $current_full_path . '/' . $_POST['filename'];
    file_put_contents($target, $_POST['content']);
    $msg = "File saved.";
}

if (isset($_POST['rename_item'])) {
    $old = $current_full_path . '/' . $_POST['old_name'];
    $new = $current_full_path . '/' . $_POST['new_name'];
    rename($old, $new);
    header("Location: index.php?dir=$current_rel_path"); exit;
}

if (isset($_GET['delete'])) {
    $target = $current_full_path . '/' . $_GET['delete'];
    is_dir($target) ? rmdir($target) : unlink($target);
    header("Location: index.php?dir=$current_rel_path"); exit;
}

if (isset($_POST['create_item'])) {
    $target = $current_full_path . '/' . $_POST['name'];
    $_POST['type'] == 'folder' ? mkdir($target) : file_put_contents($target, "");
}

if (isset($_FILES['upload'])) {
    move_uploaded_file($_FILES['upload']['tmp_name'], $current_full_path . '/' . $_FILES['upload']['name']);
}

$items = scandir($current_full_path);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>ANL IDE | Cloud Management</title>
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons+Outlined" rel="stylesheet">
    <style>
        :root { --gold: #d4af37; --bg: #050505; --sidebar: #0a0a0a; --border: #1a1a1a; --text: #888; }
        body, html { height: 100%; margin: 0; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; background: var(--bg); color: white; overflow: hidden; }
        
        /* Layout Grid */
        .app-wrapper { display: grid; grid-template-columns: 320px 1fr; height: 100vh; }

        /* Sidebar Style */
        .sidebar { background: var(--sidebar); border-right: 1px solid var(--border); display: flex; flex-direction: column; }
        .sidebar-header { padding: 20px; border-bottom: 1px solid var(--border); }
        .brand { font-weight: 900; color: var(--gold); font-size: 1.1rem; letter-spacing: 2px; }
        .file-list { flex: 1; overflow-y: auto; padding: 10px 0; }
        
        .item { display: flex; align-items: center; justify-content: space-between; padding: 8px 20px; cursor: pointer; text-decoration: none; color: var(--text); font-size: 0.85rem; }
        .item:hover { background: #111; color: white; }
        .item.active { background: #151515; border-left: 3px solid var(--gold); color: white; }
        .item-info { display: flex; align-items: center; gap: 10px; overflow: hidden; }
        .item-actions { display: none; gap: 8px; }
        .item:hover .item-actions { display: flex; }
        .icon { font-size: 18px; }

        /* Main Editor Style */
        .editor-pane { display: flex; flex-direction: column; background: #000; }
        .toolbar { background: #0a0a0a; padding: 10px 20px; display: flex; justify-content: space-between; align-items: center; border-bottom: 1px solid var(--border); }
        .btn { background: none; border: 1px solid #333; color: #ccc; padding: 6px 12px; border-radius: 6px; font-size: 0.75rem; cursor: pointer; display: flex; align-items: center; gap: 5px; text-decoration: none; }
        .btn:hover { border-color: var(--gold); color: white; }
        .btn-gold { background: var(--gold); color: black; border: none; font-weight: bold; }

        textarea { flex: 1; background: #000; color: #d4d4d4; border: none; padding: 30px; font-family: 'Consolas', 'Monaco', monospace; font-size: 15px; line-height: 1.6; resize: none; outline: none; }
        
        .empty-state { display: flex; flex-direction: column; align-items: center; justify-content: center; height: 100%; color: #222; }
        .empty-state span { font-size: 5rem; margin-bottom: 10px; }
    </style>
</head>
<body>

<div class="app-wrapper">
    <aside class="sidebar">
        <div class="sidebar-header">
            <div class="brand">ANL <span style="color:white">CLOUD</span></div>
            <div style="font-size:0.6rem; color:#444; margin-top:5px; text-transform:uppercase; letter-spacing:2px;">Explorer</div>
        </div>

        <div class="file-list">
            <?php if ($current_rel_path != ""): 
                $parent = dirname($current_rel_path);
                if ($parent == '.') $parent = '';
            ?>
                <a href="?dir=<?php echo $parent; ?>" class="item">
                    <div class="item-info"><span class="material-icons-outlined icon">arrow_back</span> ...</div>
                </a>
            <?php endif; ?>

            <?php foreach ($items as $item): 
                if ($item == '.' || $item == '..') continue;
                $full = $current_full_path . '/' . $item;
                $is_dir = is_dir($full);
                $rel = ($current_rel_path ? $current_rel_path . '/' : '') . $item;
                $isActive = (isset($_GET['edit']) && $_GET['edit'] == $item);
            ?>
                <div class="item <?php echo $isActive ? 'active' : ''; ?>">
                    <?php if ($is_dir): ?>
                        <a href="?dir=<?php echo $rel; ?>" class="item-info" style="color:inherit; text-decoration:none; flex:1;">
                            <span class="material-icons-outlined icon" style="color:var(--gold)">folder</span>
                            <span><?php echo $item; ?></span>
                        </a>
                    <?php else: ?>
                        <a href="?dir=<?php echo $current_rel_path; ?>&edit=<?php echo $item; ?>" class="item-info" style="color:inherit; text-decoration:none; flex:1;">
                            <span class="material-icons-outlined icon">description</span>
                            <span><?php echo $item; ?></span>
                        </a>
                    <?php endif; ?>

                    <div class="item-actions">
                        <span class="material-icons-outlined icon" onclick="renameItem('<?php echo $item; ?>')" style="font-size:16px;">edit</span>
                        <a href="?dir=<?php echo $current_rel_path; ?>&delete=<?php echo $item; ?>" onclick="return confirm('Hapus Permanen?')" style="color:inherit;"><span class="material-icons-outlined icon" style="font-size:16px;">delete</span></a>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>

        <div style="padding:15px; border-top:1px solid var(--border); display:flex; gap:10px;">
            <button class="btn" onclick="createItem('file')" title="New File"><span class="material-icons-outlined" style="font-size:16px;">add_box</span></button>
            <button class="btn" onclick="createItem('folder')" title="New Folder"><span class="material-icons-outlined" style="font-size:16px;">create_new_folder</span></button>
            <form method="POST" enctype="multipart/form-data" style="flex:1;">
                <input type="file" name="upload" id="up" hidden onchange="this.form.submit()">
                <label for="up" class="btn" style="justify-content:center;"><span class="material-icons-outlined" style="font-size:16px;">cloud_upload</span> UPLOAD</label>
            </form>
        </div>
    </aside>

    <main class="editor-pane">
        <?php if (isset($_GET['edit'])): 
            $file_to_edit = $current_full_path . '/' . $_GET['edit'];
            $content = file_exists($file_to_edit) ? file_get_contents($file_to_edit) : "";
        ?>
            <form method="POST" style="display:flex; flex-direction:column; height:100%;">
                <div class="toolbar">
                    <div style="font-size:0.75rem;">
                        <span style="color:#555;">Path:</span> 
                        <span style="color:var(--gold);"><?php echo $current_rel_path . '/' . $_GET['edit']; ?></span>
                    </div>
                    <div style="display:flex; gap:10px;">
                        <a href="index.php?dir=<?php echo $current_rel_path; ?>" class="btn">CLOSE</a>
                        <button type="submit" name="save_file" class="btn btn-gold">SAVE FILE</button>
                    </div>
                </div>
                <input type="hidden" name="filename" value="<?php echo $_GET['edit']; ?>">
                <textarea name="content" spellcheck="false"><?php echo htmlspecialchars($content); ?></textarea>
            </form>
        <?php else: ?>
            <div class="empty-state">
                <span class="material-icons-outlined">code_off</span>
                <p>SELECT A FILE TO START EDITING</p>
                <a href="?logout=true" style="color:#444; font-size:0.7rem; text-decoration:none;">Terminate Session</a>
            </div>
        <?php endif; ?>
    </main>
</div>

<form id="createForm" method="POST"><input type="hidden" name="create_item"><input type="hidden" name="type" id="cType"><input type="hidden" name="name" id="cName"></form>
<form id="renameForm" method="POST"><input type="hidden" name="rename_item"><input type="hidden" name="old_name" id="oldName"><input type="hidden" name="new_name" id="newName"></form>

<script>
function createItem(type) {
    let n = prompt("Create new " + type + " name:");
    if(n) {
        document.getElementById('cType').value = type;
        document.getElementById('cName').value = n;
        document.getElementById('createForm').submit();
    }
}
function renameItem(old) {
    let n = prompt("Rename '" + old + "' to:", old);
    if(n && n !== old) {
        document.getElementById('oldName').value = old;
        document.getElementById('newName').value = n;
        document.getElementById('renameForm').submit();
    }
}
</script>

</body>
</html>