<?php
/**
 * ADMIN CONTROLLER - AOE Nusantara League
 * Layout: Full Mobile Vertical Stack
 */
session_start();

// 1. KONFIGURASI
$admin_password = "admin123"; 
$file_path = '../data/data.json';
$cache_buster = time();

// 2. SISTEM LOGIN
if (isset($_POST['login'])) {
    if ($_POST['password'] === $admin_password) { $_SESSION['logged_in'] = true; } 
    else { $error = "Password Salah!"; }
}
if (isset($_GET['logout'])) { session_destroy(); header("Location: index.php"); exit; }

// Tampilan Login Mobile
if (!isset($_SESSION['logged_in'])) {
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Login | ANL</title>
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@700&display=swap" rel="stylesheet">
    <style>
        :root { --gold: #d4af37; --dark: #000; }
        body { background: var(--dark); margin: 0; font-family: sans-serif; display: flex; align-items: center; justify-content: center; height: 100vh; color: white; }
        .login-box { width: 85%; max-width: 320px; text-align: center; background: #0d0d0d; padding: 40px 20px; border-radius: 25px; border: 1px solid #222; }
        h1 { font-family: 'Cinzel', serif; color: var(--gold); margin: 0; font-size: 2rem; }
        input { width: 100%; padding: 15px; background: #000; border: 1px solid #333; color: white; border-radius: 12px; margin: 20px 0 10px; box-sizing: border-box; text-align: center; }
        button { width: 100%; padding: 15px; background: var(--gold); border: none; font-weight: bold; border-radius: 12px; cursor: pointer; width: 100%; }
        /* MODERN PROFESSIONAL FORMS */
.form-group { margin-bottom: 22px; position: relative; }

.form-group label { 
    display: block; 
    font-size: 0.65rem; 
    color: #666; 
    font-weight: 700; 
    letter-spacing: 1.5px; 
    margin-bottom: 8px; 
    text-transform: uppercase;
    padding-left: 5px;
}

.form-group input, 
.form-group select { 
    width: 100%; 
    padding: 16px; 
    background: #0a0a0a; 
    border: 1.5px solid #1a1a1a; 
    color: #fff; 
    border-radius: 14px; 
    font-size: 0.95rem; 
    box-sizing: border-box; 
    transition: all 0.3s ease;
    font-family: 'Roboto', sans-serif;
}

/* Focus State: Memberikan efek glow emas yang mewah */
.form-group input:focus, 
.form-group select:focus { 
    outline: none; 
    border-color: var(--gold); 
    background: #0f0f0f;
    box-shadow: 0 0 15px rgba(212, 175, 55, 0.1);
}

/* Professional Select Custom Arrow */
.form-group select {
    appearance: none;
    background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24' fill='none' stroke='%23d4af37' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3E%3Cpolyline points='6 9 12 15 18 9'%3E%3C/polyline%3E%3C/svg%3E");
    background-repeat: no-repeat;
    background-position: right 15px center;
    background-size: 18px;
}

::placeholder { color: #333; font-size: 0.85rem; }
    </style>
</head>
<body>
    <div class="login-box">
        <h1>ANL</h1>
        <form method="POST">
            <input type="password" name="password" placeholder="ADMIN PASSWORD" required>
            <button type="submit" name="login">LOGIN</button>
        </form>
    </div>
</body>
</html>
<?php exit; }

// 3. LOAD DATA
$data = json_decode(file_get_contents($file_path), true);
$page = $_GET['p'] ?? 'dashboard';
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Admin ANL</title>
    <link rel="stylesheet" href="../assets/style.css?v=<?php echo $cache_buster; ?>">
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@700&family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons+Outlined" rel="stylesheet">
    <style>
        :root {
            --gold: #d4af37;
            --dark: #000;
            --border: #222;
        }
        
        /* Reset Body agar stacking secara vertikal */
        body { 
            background: var(--dark); 
            margin: 0; 
            color: #eee; 
            font-family: 'Roboto', sans-serif; 
            display: block; /* Memastikan tidak ada flex di body */
            padding-bottom: 90px; /* Ruang untuk bottom nav */
        }

        /* Container Utama */
        .wrapper {
            display: flex;
            flex-direction: column; /* Memastikan konten bertumpuk ke bawah */
            width: 100%;
        }

        /* HEADER 2 BARIS */
        header { 
            width: 100%;
            padding: 40px 0 20px;
            text-align: center;
            border-bottom: 1px solid var(--border);
            display: flex;
            flex-direction: column; /* AOE di atas, Nusantara di bawah */
            align-items: center;
        }
        .header-top { 
            font-family: 'Cinzel', serif; 
            font-size: 0.8rem; 
            color: #444; 
            letter-spacing: 6px;
            margin-bottom: 2px;
        }
        .header-main { 
            font-family: 'Cinzel', serif; 
            font-size: 1.3rem; 
            color: var(--gold); 
            letter-spacing: 1px;
            font-weight: 700;
        }
        .header-main span { color: white; }

        /* AREA CONTENT (Berada tepat di bawah header) */
        .admin-container { 
            width: 100%;
            padding: 20px 15px; 
            box-sizing: border-box; 
            display: block; /* Memastikan content tidak melenceng ke samping */
        }

        /* BOTTOM NAV - Tetap di Bawah */
        .bottom-nav {
            position: fixed; 
            bottom: 0; 
            left: 0; 
            width: 100%; 
            height: 70px;
            background: rgba(10, 10, 10, 0.98); 
            border-top: 1px solid var(--border);
            display: flex; 
            justify-content: space-around; 
            align-items: center;
            z-index: 1000; 
            backdrop-filter: blur(10px);
        }
        .nav-item { 
            text-decoration: none; 
            color: #444; 
            display: flex; 
            flex-direction: column; 
            align-items: center; 
            flex: 1;
        }
        .nav-item span { font-size: 1.5rem; margin-bottom: 2px; }
        .nav-item label { font-size: 0.55rem; font-weight: bold; letter-spacing: 0.5px; }
        .nav-item.active { color: var(--gold); }
        .nav-item.logout { color: #222; }

        /* Helpers */
        .section-title { 
            color: var(--gold); 
            font-family: 'Cinzel', serif; 
            font-size: 1rem; 
            margin-bottom: 20px; 
            display: block;
            border-left: 3px solid var(--gold);
            padding-left: 10px;
        }
    </style>
</head>
<body>

    <div class="wrapper">
        <header>
            <div class="header-top">AOE</div>
            <div class="header-main">NUSANTARA <span>LEAGUE</span></div>
        </header>

        <main class="admin-container">
            <?php 
                $target = "pages/$page.php";
                if (file_exists($target)) { 
                    require $target; 
                } else { 
                    echo "<div style='text-align:center; padding-top:50px; color:#333;'>Pilih menu di bawah.</div>"; 
                }
            ?>
        </main>
    </div>

    <nav class="bottom-nav">
        <a href="?p=dashboard" class="nav-item <?php echo $page == 'dashboard' ? 'active' : ''; ?>">
            <span class="material-icons-outlined">dashboard</span>
            <label>HOME</label>
        </a>
        <a href="?p=team" class="nav-item <?php echo $page == 'team' ? 'active' : ''; ?>">
            <span class="material-icons-outlined">shield</span>
            <label>TEAMS</label>
        </a>
        <a href="?p=match" class="nav-item <?php echo $page == 'match' ? 'active' : ''; ?>">
            <span class="material-icons-outlined">event_note</span>
            <label>MATCH</label>
        </a>
        <a href="?p=player" class="nav-item <?php echo $page == 'player' ? 'active' : ''; ?>">
            <span class="material-icons-outlined">groups</span>
            <label>PLAYERS</label>
        </a>
        <a href="?p=settings" class="nav-item <?php echo $page == 'settings' ? 'active' : ''; ?>">
            <span class="material-icons-outlined">tune</span>
            <label>CONFIG</label>
        </a>
        <a href="?logout=true" class="nav-item logout" onclick="return confirm('Keluar?')">
            <span class="material-icons-outlined">logout</span>
            <label>EXIT</label>
        </a>
    </nav>

</body>
</html>